/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import java.io.ByteArrayOutputStream;

class JICPCompressor2 {
    JICPCompressor2() {
    }

    public static boolean is_separator(byte sym) {
        return sym <= 32 || sym == 40 || sym == 41 || sym == 64 || sym == 58 || sym == 47 || sym == 33;
    }

    private static int next(int val) {
        return val == 252 ? 0 : val + 1;
    }

    private static int back(int val, int num) {
        return num > val ? 253 + val - num : val - num;
    }

    private static int sum(int val, int num) {
        return num + val >= 253 ? val + num - 253 : val + num;
    }

    private static int min(int a, int b) {
        return a > b ? b : a;
    }

    public static byte[] compress(byte[] data) {
        if (data == null) {
            return null;
        }
        int dataSize = data.length;
        byte[] result = null;
        try {
            int[] words = new int[JICPCompressor2.min(dataSize + 1, 253)];
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            stream.write(dataSize / 256);
            stream.write(dataSize % 256);
            int numWords = 0;
            int pos = 0;
            boolean inWord = false;
            boolean dataEnded = false;
            while (pos < dataSize && numWords < 126) {
                if (JICPCompressor2.is_separator(data[pos]) || !inWord) {
                    inWord = !JICPCompressor2.is_separator(data[pos]);
                    words[numWords] = pos;
                    ++numWords;
                }
                ++pos;
            }
            if (numWords < 126) {
                dataEnded = true;
                words[numWords] = pos;
            }
            int countWords = 0;
            int charCounter = 0;
            boolean startFlag = true;
            int i = 0;
            while (i != numWords) {
                if (!dataEnded) {
                    while (pos < dataSize && !JICPCompressor2.is_separator(data[pos]) && inWord) {
                        ++pos;
                    }
                    if (pos < dataSize && (JICPCompressor2.is_separator(data[pos]) || !inWord)) {
                        inWord = !JICPCompressor2.is_separator(data[pos]);
                        words[numWords] = pos++;
                        numWords = JICPCompressor2.next(numWords);
                    } else {
                        words[numWords] = pos;
                        dataEnded = true;
                    }
                }
                int j = startFlag && i < 126 ? 0 : JICPCompressor2.back(i, 126);
                while (j != i) {
                    charCounter = 0;
                    countWords = 0;
                    while (words[i] + charCounter < dataSize - 1 && words[j] + charCounter < words[i] && data[words[i] + charCounter] == data[words[j] + charCounter]) {
                        if (JICPCompressor2.sum(j, countWords + 1) == i || words[j] + ++charCounter < words[JICPCompressor2.sum(j, countWords + 1)] || JICPCompressor2.sum(i, countWords + 1) == numWords || words[i] + charCounter < words[JICPCompressor2.sum(i, countWords + 1)]) continue;
                        ++countWords;
                    }
                    if (countWords > 0) {
                        if (countWords == 1 && words[JICPCompressor2.next(i)] - words[i] <= 2) {
                            int k = 0;
                            while (k < words[JICPCompressor2.next(i)] - words[i]) {
                                if (data[words[i] + k] >= 0) {
                                    stream.write(data[words[i] + k]);
                                } else {
                                    stream.write(-127);
                                    stream.write(data[words[i] + k]);
                                }
                                ++k;
                            }
                            break;
                        }
                        stream.write(-JICPCompressor2.back(i, j));
                        stream.write(-countWords);
                        i = JICPCompressor2.sum(i, countWords - 1);
                        break;
                    }
                    j = JICPCompressor2.next(j);
                }
                if (countWords == 0) {
                    j = 0;
                    while (j < words[JICPCompressor2.next(i)] - words[i]) {
                        if (data[words[i] + j] >= 0) {
                            stream.write(data[words[i] + j]);
                        } else {
                            stream.write(-127);
                            stream.write(data[words[i] + j]);
                        }
                        ++j;
                    }
                }
                if (i == 252) {
                    startFlag = false;
                }
                i = JICPCompressor2.next(i);
            }
            result = stream.toByteArray();
            return result;
        }
        catch (Exception e) {
            System.out.println("Compression exception:" + e.toString());
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decompress(byte[] data) {
        if (data == null) {
            return null;
        }
        int dataSize = data.length;
        int outputSize = (data[0] >= 0 ? data[0] : 256 + data[0]) * 256 + (data[1] >= 0 ? data[1] : 256 + data[1]);
        byte[] output = new byte[outputSize];
        int[] words = new int[JICPCompressor2.min(outputSize, 253)];
        int numWords = 0;
        int j = 0;
        int i = 2;
        try {
            i = 2;
            while (i < dataSize) {
                if (data[i] < 0 && data[i] > -127) {
                    int wordsCount = i + 1 < dataSize && data[i + 1] < 0 && data[i + 1] > -127 ? -data[i + 1] : 1;
                    int symCount = words[JICPCompressor2.sum(JICPCompressor2.back(numWords, -data[i]), wordsCount)] - words[JICPCompressor2.back(numWords, -data[i])];
                    int k = 0;
                    while (k < symCount) {
                        output[j + k] = output[words[JICPCompressor2.back(numWords, -data[i])] + k];
                        ++k;
                    }
                    k = 0;
                    while (k < wordsCount) {
                        words[JICPCompressor2.sum((int)numWords, (int)k)] = words[JICPCompressor2.sum(JICPCompressor2.back(numWords, -data[i]), k)] - words[JICPCompressor2.back(numWords, -data[i])] + j;
                        ++k;
                    }
                    j += symCount;
                    numWords = JICPCompressor2.sum(numWords, wordsCount);
                    i += 2;
                    continue;
                }
                if (!JICPCompressor2.is_separator(data[i])) {
                    words[numWords] = j;
                    numWords = JICPCompressor2.next(numWords);
                    output[j] = data[i];
                    ++i;
                    ++j;
                }
                while (i < dataSize && !JICPCompressor2.is_separator(data[i])) {
                    output[j] = data[i];
                    ++i;
                    ++j;
                }
                while (i < dataSize && JICPCompressor2.is_separator(data[i]) && (data[i] >= 0 || data[i] == -127)) {
                    if (data[i] == -127) {
                        ++i;
                    }
                    words[numWords] = j;
                    numWords = JICPCompressor2.next(numWords);
                    output[j] = data[i];
                    ++i;
                    ++j;
                }
            }
            return output;
        }
        catch (Exception e) {
            System.out.println("Decompression exception:" + e.toString());
            e.printStackTrace();
            return null;
        }
    }
}

